
import { ApiKeyManager } from "@esri/arcgis-rest-request";
import { addFeatures, updateFeatures, deleteFeatures } from "@esri/arcgis-rest-feature-service";

const accessToken = "YOUR_ACCESS_TOKEN";
const authentication = ApiKeyManager.fromKey(accessToken);

const featureServiceLayerUrl = "https://services3.arcgis.com/GVgbJbqm8hXASVYi/ArcGIS/rest/services/my_points/FeatureServer/0";

const featureToAdd = {
  attributes: {
    id: 101,
    name: "editing test",
    rating: "2"
  },
  geometry: {
    x: -118.807,
    y: 34.002,
    spatialReference: {
      wkid: 4326
    }
  }
};

addFeatures({
  url: featureServiceLayerUrl,
  features: [featureToAdd],
  authentication
}).then(async (response) => {
  console.log(JSON.stringify(response, null, 2));

  if (!response.addResults[0].success) {
    return;
  }

  const featureToUpdate = {
    attributes: {
      objectId: response.addResults[0].objectId,
      name: "new name",
      rating: "3"
    }
  };

  const updateResponse = await updateFeatures({
    url: featureServiceLayerUrl,
    features: [featureToUpdate],
    authentication
  });

  console.log(updateResponse);

  if (!updateResponse.updateResults[0].success) {
    return;
  }

  const featureToDelete = [updateResponse.updateResults[0].objectId];

  const deleteResponse = await deleteFeatures({
    url: featureServiceLayerUrl,
    objectIds: [featureToDelete],
    authentication
  });

  console.log(deleteResponse);

});


