
import { ApiKeyManager } from "@esri/arcgis-rest-request";
import { queryFeatures } from "@esri/arcgis-rest-feature-service";

const accessToken = "YOUR_ACCESS_TOKEN";
const authentication = ApiKeyManager.fromKey(accessToken);

const queryGeometry = {
  x: -118.807,
  y: 34.002,
  spatialReference: {
    wkid: 4326
  }
};

queryFeatures({
  url: "https://services3.arcgis.com/GVgbJbqm8hXASVYi/arcgis/rest/services/LA_County_Parcels/FeatureServer/0",
  geometry: queryGeometry,
  geometryType: "esriGeometryPoint",
  spatialRel: "esriSpatialRelIntersects",
  authentication
}).then((response) => {
  console.log(response.features);
});


