/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import com.esri.interceptor.helpers.PBFUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;
import org.json.JSONObject;

public class Enrich {
    public static String convertToString(byte[] data, String charEncoding) {
        String original;
        try {
            original = new String(data, Charset.forName(charEncoding == null || charEncoding.isEmpty() ? StandardCharsets.UTF_8.name() : charEncoding));
        }
        catch (IllegalArgumentException ex) {
            original = new String(data, StandardCharsets.UTF_8);
        }
        return original;
    }

    public static String appendJSONStringResponse(String responseString) {
        JSONObject responseJson = new JSONObject(responseString);
        if (responseJson.has("features")) {
            JSONArray featuresArray = responseJson.getJSONArray("features");
            for (int i = 0; i < featuresArray.length(); ++i) {
                JSONObject feature = featuresArray.getJSONObject(i);
                if (!feature.has("attributes")) continue;
                JSONObject attributes = feature.optJSONObject("attributes");
                if (attributes.has("agency")) {
                    attributes.put("agency", (Object)"NYPD");
                }
                if (attributes.has("agency_name")) {
                    attributes.put("agency_name", (Object)"New York City Police Department");
                }
                if (!attributes.has("status")) continue;
                attributes.put("status", (Object)"In Progress");
            }
        }
        return responseJson.toString(2);
    }

    public static byte[] appendPBFResponse(byte[] responseBytes) throws IOException {
        return PBFUtils.getFeatureCollAsBytes(responseBytes);
    }
}

