/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.samples;

import com.esri.arcgis.enterprise.interceptor.IInterceptorConfig;
import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.Interceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerInterceptorLogger;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorChain;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorHelper;
import com.esri.interceptor.helpers.Enrich;
import com.esri.interceptor.samples.REServiceInterceptorResponse;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Map;

@Interceptor(name="ResponseEnrichment", displayName="Response Enrichment Interceptor", description="Response Enrichment Interceptor", urlPatterns={"Hosted/incidents/FeatureServer"}, properties={"prop1=value1"}, chainingOrder=3)
public class ResponseEnrichment
implements IServerServicesInterceptor {
    private IServerServicesInterceptorHelper interceptorHelper;

    public void init(IInterceptorConfig interceptorConfig, IServerServicesInterceptorHelper interceptorHelper, IServerInterceptorLogger logger) {
        this.interceptorHelper = interceptorHelper;
    }

    public void intercept(IInterceptorRequest request, IInterceptorResponse response, IServerServicesInterceptorChain filterChain) throws IOException, ServletException {
        if (!filterChain.isRestRequestChain()) {
            filterChain.intercept(request, response);
            return;
        }
        REServiceInterceptorResponse serviceResponseWrapper = new REServiceInterceptorResponse(response);
        String operationName = this.interceptorHelper.getOperationName(request, (IInterceptorResponse)serviceResponseWrapper);
        filterChain.intercept(request, (IInterceptorResponse)serviceResponseWrapper);
        if ("query".equalsIgnoreCase(operationName)) {
            Map p = request.getParameterMap();
            String f = ResponseEnrichment.first((String[])p.get("f"));
            boolean isPbf = "pbf".equalsIgnoreCase(f);
            boolean hasObjectIds = p.containsKey("objectIds");
            boolean idsOnly = "true".equalsIgnoreCase(ResponseEnrichment.first((String[])p.get("returnIdsOnly")));
            boolean cntOnly = "true".equalsIgnoreCase(ResponseEnrichment.first((String[])p.get("returnCountOnly")));
            if (!idsOnly && !cntOnly && hasObjectIds) {
                if (isPbf) {
                    byte[] enrichedPBF = Enrich.appendPBFResponse(serviceResponseWrapper.getResponseDataAsBytes(true));
                    serviceResponseWrapper.sendResponse(response, enrichedPBF, true);
                    return;
                }
                if ("json".equalsIgnoreCase(f) || "pjson".equalsIgnoreCase(f)) {
                    String original = Enrich.convertToString(serviceResponseWrapper.getResponseDataAsBytes(true), serviceResponseWrapper.getCharacterEncoding());
                    String enriched = Enrich.appendJSONStringResponse(original);
                    serviceResponseWrapper.sendResponse(response, enriched.getBytes(serviceResponseWrapper.getCharacterEncoding()), true);
                    return;
                }
            }
        }
        serviceResponseWrapper.sendResponse(response, null, false);
    }

    public void cleanup() {
    }

    private static String first(String[] a) {
        return a != null && a.length > 0 ? a[0] : null;
    }
}

