/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import com.esri.interceptor.helpers.PBFUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.json.JSONArray;
import org.json.JSONObject;

public class Enrich {
    public static JSONArray appendJSONStringRequest(JSONArray editsArray) {
        for (int i = 0; i < editsArray.length(); ++i) {
            JSONObject addObject = editsArray.getJSONObject(i);
            JSONObject attributes = addObject.optJSONObject("attributes");
            String incident_id = String.valueOf(attributes.get("incident_id"));
            if (incident_id != null && !incident_id.equalsIgnoreCase("null")) continue;
            attributes.put("incident_id", (Object)"INCTest");
            attributes.put("agency", (Object)"NYPD");
            attributes.put("agency_name", (Object)"New York City Police Department");
        }
        return editsArray;
    }

    public static String convertToString(byte[] data, String charEncoding) {
        String original;
        try {
            original = new String(data, Charset.forName(charEncoding == null || charEncoding.isEmpty() ? StandardCharsets.UTF_8.name() : charEncoding));
        }
        catch (IllegalArgumentException ex) {
            original = new String(data, StandardCharsets.UTF_8);
        }
        return original;
    }

    public static String appendJSONStringResponse(String responseString) {
        JSONObject responseJson = new JSONObject(responseString);
        if (responseJson.has("features")) {
            JSONArray featuresArray = responseJson.getJSONArray("features");
            for (int i = 0; i < featuresArray.length(); ++i) {
                JSONObject feature = featuresArray.getJSONObject(i);
                if (!feature.has("attributes")) continue;
                JSONObject attributes = feature.optJSONObject("attributes");
                if (attributes.has("resolution_description")) {
                    attributes.put("resolution_description", (Object)"This is a test resolution description");
                }
                if (!attributes.has("last_action_date")) continue;
                attributes.put("last_action_date", (Object)String.valueOf(Instant.now().getEpochSecond()));
            }
        }
        return responseJson.toString(2);
    }

    public static byte[] appendPBFResponse(byte[] responseBytes) throws IOException {
        return PBFUtils.getFeatureCollAsBytes(responseBytes);
    }
}

