/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import com.esri.interceptor.helpers.ArcGISCoordinateConverter;
import com.esri.interceptor.helpers.ReverseGeocodeAPI;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class Enrich {
    public static JSONArray appendLocationInformation(JSONArray editsArray) throws IOException {
        for (int i = 0; i < editsArray.length(); ++i) {
            String Y;
            JSONObject addObject = editsArray.getJSONObject(i);
            JSONObject geometry = addObject.optJSONObject("geometry");
            JSONObject attributes = addObject.optJSONObject("attributes");
            if (geometry == null || !geometry.has("x") || !geometry.has("y")) continue;
            double x = geometry.getDouble("x");
            double y = geometry.getDouble("y");
            int latestWkid = geometry.optJSONObject("spatialReference").optInt("latestWkid", -1);
            int wkid = geometry.optJSONObject("spatialReference").optInt("wkid", -1);
            double[] convertedXY = ArcGISCoordinateConverter.convertCoordinates(x, y, wkid, latestWkid, 4326);
            String X = String.valueOf(convertedXY[0]);
            String addressDetails = ReverseGeocodeAPI.retrieveDetails(X + "," + (Y = String.valueOf(convertedXY[1])));
            if (addressDetails.isEmpty() || addressDetails.contains("error")) continue;
            JSONObject addressObject = new JSONObject(addressDetails).getJSONObject("address");
            attributes.put("address", (Object)addressObject.optString("Match_addr", ""));
            attributes.put("zipcode", addressObject.optLong("Postal"));
            attributes.put("street_name", (Object)addressObject.optString("Address", ""));
            attributes.put("city", (Object)addressObject.optString("City", ""));
        }
        return editsArray;
    }
}

