/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.samples;

import com.esri.arcgis.enterprise.interceptor.IInterceptorConfig;
import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.Interceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerInterceptorLogger;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorChain;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorHelper;
import com.esri.interceptor.helpers.Enrich;
import com.esri.interceptor.samples.GeoServiceInterceptorRequest;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.json.JSONArray;

@Interceptor(name="Geocoding", displayName="Geocoding Interceptor", description="Geocoding Interceptor", urlPatterns={"Hosted/incidents/FeatureServer/0"}, properties={"prop1=value1"}, chainingOrder=1)
public class Geocoding
implements IServerServicesInterceptor {
    private IServerServicesInterceptorHelper interceptorHelper;

    public void init(IInterceptorConfig interceptorConfig, IServerServicesInterceptorHelper interceptorHelper, IServerInterceptorLogger logger) {
        this.interceptorHelper = interceptorHelper;
    }

    public void intercept(IInterceptorRequest request, IInterceptorResponse response, IServerServicesInterceptorChain filterChain) throws IOException, ServletException {
        String[] addsValues;
        Map<String, String[]> parameterMap;
        if (!filterChain.isRestRequestChain()) {
            filterChain.intercept(request, response);
            return;
        }
        GeoServiceInterceptorRequest serviceRequestWrapper = new GeoServiceInterceptorRequest(request);
        String operationName = this.interceptorHelper.getOperationName((IInterceptorRequest)serviceRequestWrapper, response);
        if ("applyEdits".equalsIgnoreCase(operationName) && (parameterMap = serviceRequestWrapper.getParameterMap()).containsKey("adds") && (addsValues = parameterMap.get("adds")) != null && addsValues.length > 0) {
            String addsJsonString = URLDecoder.decode(addsValues[0], StandardCharsets.UTF_8);
            JSONArray addsArray = new JSONArray(addsJsonString);
            Enrich.appendLocationInformation(addsArray);
            String modifiedAddsJson = addsArray.toString();
            if (modifiedAddsJson != null) {
                serviceRequestWrapper.updateParameter("adds", modifiedAddsJson);
            }
        }
        filterChain.intercept((IInterceptorRequest)serviceRequestWrapper, response);
    }

    public void cleanup() {
    }
}

