/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArcGISCoordinateConverter {
    private static final String ARCGIS_PROJECT_API = "https://utility.arcgisonline.com/arcgis/rest/services/Geometry/GeometryServer/project";

    public static double[] convertCoordinates(double x, double y, int wkid, int latestWkid, int outwkid) {
        try {
            String response;
            String geometryJson = String.format("{\"geometryType\":\"esriGeometryPoint\",\"geometries\":[{\"x\":%f,\"y\":%f,\"spatialReference\":{\"latestWkid\":%d,\"wkid\":%d}}]}", x, y, latestWkid, wkid);
            String params = "f=json&inSR=" + latestWkid + "&outSR=" + outwkid + "&geometries=" + URLEncoder.encode(geometryJson, StandardCharsets.UTF_8);
            URL url = new URL("https://utility.arcgisonline.com/arcgis/rest/services/Geometry/GeometryServer/project?" + params);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            try (InputStream inputStream = conn.getInputStream();){
                response = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            }
            JSONObject jsonResponse = new JSONObject(response);
            JSONArray geometries = jsonResponse.getJSONArray("geometries");
            if (!geometries.isEmpty()) {
                JSONObject converted = geometries.getJSONObject(0);
                return new double[]{converted.getDouble("x"), converted.getDouble("y")};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new double[]{x, y};
    }
}

