/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class ByteUtils {
    private static final int BUF = 16384;
    public static final String ENC_IDENTITY = "identity";
    public static final String ENC_GZIP = "gzip";
    public static final String ENC_DEFLATE = "deflate";
    public static final String ENC_ZLIB = "zlib";
    public static final String ENC_RAW_DEFLATE = "raw-deflate";

    private ByteUtils() {
    }

    public static byte[] compress(byte[] data, String contentEncoding) throws IOException {
        String enc;
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        if (contentEncoding == null || contentEncoding.isEmpty() || ENC_IDENTITY.equalsIgnoreCase(contentEncoding)) {
            return data;
        }
        switch (enc = contentEncoding.toLowerCase()) {
            case "gzip": {
                return ByteUtils.gzipCompress(data);
            }
            case "deflate": 
            case "zlib": {
                return ByteUtils.zlibCompress(data);
            }
            case "raw-deflate": {
                return ByteUtils.rawDeflateCompress(data);
            }
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    public static byte[] decompress(byte[] data, String contentEncoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] decompress(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return data;
        }
        if (ByteUtils.looksLikeGzip(data)) {
            try {
                return ByteUtils.gzipDecompress(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ByteUtils.looksLikeZlib(data)) {
            try {
                return ByteUtils.zlibDecompress(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return ByteUtils.zlibDecompress(data);
        }
        catch (IOException iOException) {
            try {
                return ByteUtils.rawDeflateDecompress(data);
            }
            catch (IOException iOException2) {
                return data;
            }
        }
    }

    private static boolean looksLikeGzip(byte[] d) {
        return d.length >= 2 && d[0] == 31 && d[1] == -117;
    }

    private static byte[] gzipCompress(byte[] uncompressed) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream(out);){
            gos.write(uncompressed);
        }
        return out.toByteArray();
    }

    private static byte[] gzipDecompress(byte[] gz) throws IOException {
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(gz));){
            byte[] byArray = ByteUtils.toByteArray(gis);
            return byArray;
        }
    }

    private static boolean looksLikeZlib(byte[] d) {
        if (d.length < 2) {
            return false;
        }
        int cmf = d[0] & 0xFF;
        int flg = d[1] & 0xFF;
        if ((cmf & 0xF) != 8) {
            return false;
        }
        return ((cmf << 8) + flg) % 31 == 0;
    }

    private static byte[] zlibCompress(byte[] uncompressed) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)out, new Deflater(-1, false));){
            dos.write(uncompressed);
        }
        return out.toByteArray();
    }

    private static byte[] zlibDecompress(byte[] z) throws IOException {
        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(z), new Inflater(false));){
            byte[] byArray = ByteUtils.toByteArray(iis);
            return byArray;
        }
    }

    private static byte[] rawDeflateCompress(byte[] uncompressed) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)out, new Deflater(-1, true));){
            dos.write(uncompressed);
        }
        return out.toByteArray();
    }

    private static byte[] rawDeflateDecompress(byte[] raw) throws IOException {
        Inflater inflater = new Inflater(true);
        try {
            byte[] byArray;
            try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(raw), inflater);){
                byArray = ByteUtils.toByteArray(iis);
            }
            return byArray;
        }
        finally {
            inflater.end();
        }
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[16384];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }
}

