/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import com.esri.interceptor.helpers.ArcGISCoordinateConverter;
import com.esri.interceptor.helpers.PBFUtils;
import com.esri.interceptor.helpers.ReverseGeocodeAPI;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.json.JSONArray;
import org.json.JSONObject;

public class Enrich {
    public static void appendLocationInformation(JSONArray editsArray) throws IOException {
        for (int i = 0; i < editsArray.length(); ++i) {
            String Y;
            JSONObject addObject = editsArray.getJSONObject(i);
            JSONObject geometry = addObject.optJSONObject("geometry");
            JSONObject attributes = addObject.optJSONObject("attributes");
            if (geometry == null || !geometry.has("x") || !geometry.has("y")) continue;
            double x = geometry.getDouble("x");
            double y = geometry.getDouble("y");
            int latestWkid = geometry.optJSONObject("spatialReference").optInt("latestWkid", -1);
            int wkid = geometry.optJSONObject("spatialReference").optInt("wkid", -1);
            double[] convertedXY = ArcGISCoordinateConverter.convertCoordinates(x, y, wkid, latestWkid, 4326);
            String X = String.valueOf(convertedXY[0]);
            String addressDetails = ReverseGeocodeAPI.retrieveDetails(X + "," + (Y = String.valueOf(convertedXY[1])));
            if (addressDetails.isEmpty() || addressDetails.contains("error")) continue;
            JSONObject addressObject = new JSONObject(addressDetails).getJSONObject("address");
            attributes.put("address", (Object)addressObject.optString("Match_addr", ""));
            attributes.put("zipcode", addressObject.optLong("Postal"));
            attributes.put("street_name", (Object)addressObject.optString("Address", ""));
            attributes.put("city", (Object)addressObject.optString("City", ""));
        }
    }

    public static JSONArray appendJSONStringRequest(JSONArray editsArray) {
        for (int i = 0; i < editsArray.length(); ++i) {
            JSONObject addObject = editsArray.getJSONObject(i);
            JSONObject attributes = addObject.optJSONObject("attributes");
            String incident_id = String.valueOf(attributes.get("incident_id"));
            if (incident_id != null && !incident_id.equalsIgnoreCase("null")) continue;
            attributes.put("incident_id", (Object)"INCTest");
            attributes.put("agency", (Object)"NYPD");
            attributes.put("agency_name", (Object)"New York City Police Department");
        }
        return editsArray;
    }

    public static String convertToString(byte[] data, String charEncoding) {
        String original;
        try {
            original = new String(data, Charset.forName(charEncoding == null || charEncoding.isEmpty() ? StandardCharsets.UTF_8.name() : charEncoding));
        }
        catch (IllegalArgumentException ex) {
            original = new String(data, StandardCharsets.UTF_8);
        }
        return original;
    }

    public static String appendJSONStringResponse(String responseString) {
        JSONObject responseJson = new JSONObject(responseString);
        if (responseJson.has("features")) {
            JSONArray featuresArray = responseJson.getJSONArray("features");
            for (int i = 0; i < featuresArray.length(); ++i) {
                JSONObject feature = featuresArray.getJSONObject(i);
                if (!feature.has("attributes")) continue;
                JSONObject attributes = feature.optJSONObject("attributes");
                if (attributes.has("agency")) {
                    attributes.put("agency", (Object)"NYPD");
                }
                if (attributes.has("agency_name")) {
                    attributes.put("agency_name", (Object)"New York City Police Department");
                }
                if (attributes.has("status")) {
                    attributes.put("status", (Object)"In Progress");
                }
                if (attributes.has("resolution_description")) {
                    attributes.put("resolution_description", (Object)"This is a test resolution description");
                }
                if (!attributes.has("last_action_date")) continue;
                attributes.put("last_action_date", (Object)String.valueOf(Instant.now().getEpochSecond()));
            }
        }
        return responseJson.toString(2);
    }

    public static byte[] appendPBFResponse(byte[] responseBytes) throws IOException {
        return PBFUtils.getFeatureCollAsBytes(responseBytes);
    }
}

