/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.helpers;

import com.esri.arcgis.protobuf.FeatureCollection;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PBFUtils {
    public static byte[] getFeatureCollAsBytes(byte[] inputData) throws IOException {
        FeatureCollection.FeatureCollectionPBuffer fc;
        try {
            fc = FeatureCollection.FeatureCollectionPBuffer.parseFrom((byte[])inputData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FeatureCollection.FeatureCollectionPBuffer.QueryResult srcQR = fc.getQueryResult();
        FeatureCollection.FeatureCollectionPBuffer.QueryResult updatedQR = PBFUtils.createQueryResultWithUpdates(srcQR);
        return FeatureCollection.FeatureCollectionPBuffer.newBuilder((FeatureCollection.FeatureCollectionPBuffer)fc).setQueryResult(updatedQR).build().toByteArray();
    }

    private static FeatureCollection.FeatureCollectionPBuffer.QueryResult createQueryResultWithUpdates(FeatureCollection.FeatureCollectionPBuffer.QueryResult srcQR) {
        FeatureCollection.FeatureCollectionPBuffer.QueryResult.Builder qb = FeatureCollection.FeatureCollectionPBuffer.QueryResult.newBuilder((FeatureCollection.FeatureCollectionPBuffer.QueryResult)srcQR);
        switch (srcQR.getResultsCase()) {
            case FEATURERESULT: {
                qb.setFeatureResult(PBFUtils.createFeatureResultsWithUpdates(srcQR.getFeatureResult()));
                break;
            }
        }
        return qb.build();
    }

    private static FeatureCollection.FeatureCollectionPBuffer.FeatureResult createFeatureResultsWithUpdates(FeatureCollection.FeatureCollectionPBuffer.FeatureResult srcFR) {
        FeatureCollection.FeatureCollectionPBuffer.FeatureResult.Builder frb = FeatureCollection.FeatureCollectionPBuffer.FeatureResult.newBuilder((FeatureCollection.FeatureCollectionPBuffer.FeatureResult)srcFR);
        List fields = srcFR.getFieldsList();
        HashMap<String, Integer> fieldIndex = new HashMap<String, Integer>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldIndex.put(((FeatureCollection.FeatureCollectionPBuffer.Field)fields.get(i)).getName(), i);
        }
        Integer agencyIdx = fieldIndex.getOrDefault("agency", -1);
        Integer agencyNameIdx = fieldIndex.getOrDefault("agency_name", -1);
        Integer statusIdx = fieldIndex.getOrDefault("status", -1);
        Integer resDescIdx = fieldIndex.getOrDefault("resolution_description", -1);
        Integer lastActionIdx = fieldIndex.getOrDefault("last_action_date", -1);
        List srcFeatures = srcFR.getFeaturesList();
        ArrayList<FeatureCollection.FeatureCollectionPBuffer.Feature> newFeatures = new ArrayList<FeatureCollection.FeatureCollectionPBuffer.Feature>(srcFeatures.size());
        for (FeatureCollection.FeatureCollectionPBuffer.Feature srcF : srcFeatures) {
            FeatureCollection.FeatureCollectionPBuffer.Field lastActionField;
            FeatureCollection.FeatureCollectionPBuffer.Feature.Builder fb = FeatureCollection.FeatureCollectionPBuffer.Feature.newBuilder((FeatureCollection.FeatureCollectionPBuffer.Feature)srcF);
            ArrayList<FeatureCollection.FeatureCollectionPBuffer.Value> attrs = new ArrayList<FeatureCollection.FeatureCollectionPBuffer.Value>(srcF.getAttributesList());
            if (agencyIdx >= 0) {
                PBFUtils.ensureSize(attrs, fields.size());
                attrs.set(agencyIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setStringValue("NYPD").build());
            }
            if (agencyNameIdx >= 0) {
                PBFUtils.ensureSize(attrs, fields.size());
                attrs.set(agencyNameIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setStringValue("New York City Police Department").build());
            }
            if (statusIdx >= 0) {
                PBFUtils.ensureSize(attrs, fields.size());
                attrs.set(statusIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setStringValue("In Progress").build());
            }
            if (resDescIdx >= 0) {
                PBFUtils.ensureSize(attrs, fields.size());
                attrs.set(resDescIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setStringValue("This is a test resolution description").build());
            }
            if (lastActionIdx >= 0 && lastActionIdx < fields.size() && (lastActionField = (FeatureCollection.FeatureCollectionPBuffer.Field)fields.get(lastActionIdx)) != null) {
                PBFUtils.ensureSize(attrs, fields.size());
                FeatureCollection.FeatureCollectionPBuffer.FieldType t = lastActionField.getFieldType();
                if (t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeSmallInteger || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeInteger) {
                    attrs.set(lastActionIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setInt64Value(System.currentTimeMillis()).build());
                } else if (t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeDate) {
                    attrs.set(lastActionIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setInt64Value(System.currentTimeMillis()).build());
                } else if (PBFUtils.isStringLike(t)) {
                    String iso = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    attrs.set(lastActionIdx, FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().setStringValue(iso).build());
                }
            }
            fb.clearAttributes();
            fb.addAllAttributes(attrs);
            newFeatures.add(fb.build());
        }
        frb.clearFeatures();
        frb.addAllFeatures(newFeatures);
        return frb.build();
    }

    private static void ensureSize(List<FeatureCollection.FeatureCollectionPBuffer.Value> attrs, int targetSize) {
        while (attrs.size() < targetSize) {
            attrs.add(FeatureCollection.FeatureCollectionPBuffer.Value.newBuilder().build());
        }
    }

    private static boolean isStringLike(FeatureCollection.FeatureCollectionPBuffer.FieldType t) {
        return t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeString || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeGUID || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeGlobalID || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeXML || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeDateOnly || t == FeatureCollection.FeatureCollectionPBuffer.FieldType.esriFieldTypeTimeOnly;
    }
}

