/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.samples;

import com.esri.arcgis.enterprise.interceptor.IInterceptorConfig;
import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.Interceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerInterceptorLogger;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorChain;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorHelper;
import com.esri.interceptor.helpers.Enrich;
import com.esri.interceptor.samples.ServiceInterceptorRequest;
import com.esri.interceptor.samples.ServiceInterceptorResponse;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.json.JSONArray;

@Interceptor(name="IncidentManagement", displayName="Incident Management Interceptor", description="Incident Management Interceptor", urlPatterns={"Hosted/incidents/FeatureServer"}, properties={"prop1=value1"}, chainingOrder=1)
public class IncidentManagement
implements IServerServicesInterceptor {
    private IServerServicesInterceptorHelper interceptorHelper;

    public void init(IInterceptorConfig interceptorConfig, IServerServicesInterceptorHelper interceptorHelper, IServerInterceptorLogger logger) {
        this.interceptorHelper = interceptorHelper;
    }

    public void intercept(IInterceptorRequest request, IInterceptorResponse response, IServerServicesInterceptorChain filterChain) throws IOException, ServletException {
        String[] addsValues;
        Map<String, String[]> parameterMap;
        if (!filterChain.isRestRequestChain()) {
            filterChain.intercept(request, response);
            return;
        }
        ServiceInterceptorRequest serviceRequestWrapper = new ServiceInterceptorRequest(request);
        ServiceInterceptorResponse serviceResponseWrapper = new ServiceInterceptorResponse(response);
        String operationName = this.interceptorHelper.getOperationName((IInterceptorRequest)serviceRequestWrapper, (IInterceptorResponse)serviceResponseWrapper);
        if ("applyEdits".equalsIgnoreCase(operationName) && (parameterMap = serviceRequestWrapper.getParameterMap()).containsKey("adds") && (addsValues = parameterMap.get("adds")) != null && addsValues.length > 0) {
            String addsJsonString = URLDecoder.decode(addsValues[0], StandardCharsets.UTF_8);
            JSONArray addsArray = new JSONArray(addsJsonString);
            Enrich.appendLocationInformation(addsArray);
            Enrich.appendJSONStringRequest(addsArray);
            String modifiedAddsJson = addsArray.toString();
            if (modifiedAddsJson != null) {
                serviceRequestWrapper.updateParameter("adds", modifiedAddsJson);
            }
        }
        filterChain.intercept((IInterceptorRequest)serviceRequestWrapper, (IInterceptorResponse)serviceResponseWrapper);
        if ("query".equalsIgnoreCase(operationName)) {
            Map<String, String[]> p = serviceRequestWrapper.getParameterMap();
            String f = IncidentManagement.first(p.get("f"));
            boolean isPbf = "pbf".equalsIgnoreCase(f);
            boolean hasObjectIds = p.containsKey("objectIds");
            boolean idsOnly = "true".equalsIgnoreCase(IncidentManagement.first(p.get("returnIdsOnly")));
            boolean cntOnly = "true".equalsIgnoreCase(IncidentManagement.first(p.get("returnCountOnly")));
            if (!idsOnly && !cntOnly && hasObjectIds) {
                if (isPbf) {
                    byte[] enrichedPBF = Enrich.appendPBFResponse(serviceResponseWrapper.getResponseDataAsBytes(true));
                    serviceResponseWrapper.sendResponse(response, enrichedPBF, true);
                    return;
                }
                if ("json".equalsIgnoreCase(f) || "pjson".equalsIgnoreCase(f)) {
                    String original = Enrich.convertToString(serviceResponseWrapper.getResponseDataAsBytes(true), serviceResponseWrapper.getCharacterEncoding());
                    String enriched = Enrich.appendJSONStringResponse(original);
                    serviceResponseWrapper.sendResponse(response, enriched.getBytes(serviceResponseWrapper.getCharacterEncoding()), true);
                    return;
                }
            }
        }
        serviceResponseWrapper.sendResponse(response, null, false);
    }

    public void cleanup() {
    }

    private static String first(String[] a) {
        return a != null && a.length > 0 ? a[0] : null;
    }
}

