/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.samples;

import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.server.ServerServicesInterceptorResponseWrapper;
import com.esri.interceptor.helpers.ByteUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ServiceInterceptorResponse
extends ServerServicesInterceptorResponseWrapper {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private PrintWriter printWriter;
    private ServletOutputStream servletOutputStream;
    private boolean writerUsed = false;
    private boolean streamUsed = false;
    private final String characterEncoding = StandardCharsets.UTF_8.name();

    public ServiceInterceptorResponse(IInterceptorResponse interceptorResponse) {
        super(interceptorResponse);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.streamUsed) {
            throw new IllegalStateException("getOutputStream() already called");
        }
        if (this.printWriter == null) {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.byteArrayOutputStream, Charset.forName(this.characterEncoding));
            this.printWriter = new PrintWriter((Writer)osw, true);
            this.writerUsed = true;
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writerUsed) {
            throw new IllegalStateException("getWriter() already called");
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new ServletOutputStream(){

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    ServiceInterceptorResponse.this.byteArrayOutputStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    ServiceInterceptorResponse.this.byteArrayOutputStream.write(b, off, len);
                }
            };
            this.streamUsed = true;
        }
        return this.servletOutputStream;
    }

    public void flushBuffer() throws IOException {
        if (this.writerUsed && this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.streamUsed && this.servletOutputStream != null) {
            this.byteArrayOutputStream.flush();
        }
    }

    public void resetBuffer() {
        this.byteArrayOutputStream.reset();
    }

    public void closeQuietly() {
        try {
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean wroteViaWriter() {
        return this.writerUsed;
    }

    public boolean wroteViaStream() {
        return this.streamUsed;
    }

    public int getBufferedSize() {
        return this.byteArrayOutputStream.size();
    }

    public byte[] getResponseDataAsBytes(boolean tryDecompress) throws IOException {
        this.flushBuffer();
        byte[] raw = this.byteArrayOutputStream.toByteArray();
        if (!tryDecompress) {
            return raw;
        }
        try {
            byte[] maybe = ByteUtils.decompress(raw);
            return maybe != null ? maybe : raw;
        }
        catch (Exception e) {
            return raw;
        }
    }

    public void sendResponse(IInterceptorResponse originalResponse, byte[] enrichedResponse, boolean compress) throws IOException {
        byte[] out;
        String contentEncoding = this.getHeader("Content-Encoding");
        if (enrichedResponse == null || enrichedResponse.length == 0) {
            compress = false;
            enrichedResponse = this.getResponseDataAsBytes(false);
        }
        byte[] byArray = out = compress ? ByteUtils.compress(enrichedResponse, contentEncoding) : enrichedResponse;
        if (!originalResponse.isCommitted()) {
            originalResponse.resetBuffer();
        }
        if (compress && !contentEncoding.isEmpty()) {
            try {
                originalResponse.getClass().getMethod("setContentLengthLong", Long.TYPE).invoke((Object)originalResponse, out.length);
            }
            catch (Throwable t) {
                originalResponse.setContentLength(out.length);
            }
        }
        if (out == null || out.length == 0) {
            out = new byte[]{};
        }
        originalResponse.getOutputStream().write(out);
        originalResponse.getOutputStream().flush();
    }
}

