/*
 * Decompiled with CFR 0.152.
 */
package com.esri.interceptor.samples;

import com.esri.arcgis.enterprise.interceptor.IInterceptorConfig;
import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.Interceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerInterceptorLogger;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorChain;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorHelper;
import jakarta.servlet.ServletException;
import java.io.IOException;

@Interceptor(name="AuditLogInterceptor", displayName="Audit Log Interceptor", description="Audit Log Interceptor", urlPatterns={"test"}, properties={"prop1=value1"}, chainingOrder=1)
public class AuditLogInterceptor
implements IServerServicesInterceptor {
    private IServerServicesInterceptorHelper interceptorHelper;
    private IServerInterceptorLogger logger;

    public void init(IInterceptorConfig interceptorConfig, IServerServicesInterceptorHelper interceptorHelper, IServerInterceptorLogger logger) {
        this.interceptorHelper = interceptorHelper;
        this.logger = logger;
    }

    public void intercept(IInterceptorRequest request, IInterceptorResponse response, IServerServicesInterceptorChain filterChain) throws IOException, ServletException {
        if (!filterChain.isRestRequestChain()) {
            filterChain.intercept(request, response);
            return;
        }
        this.logUserAction(request, response);
        filterChain.intercept(request, response);
    }

    public void cleanup() {
    }

    private void logUserAction(IInterceptorRequest request, IInterceptorResponse response) {
        String username = this.interceptorHelper.getUsername(request, response);
        String serviceName = this.interceptorHelper.getServiceName(request, response);
        String serviceType = this.interceptorHelper.getServiceType(request, response);
        String serviceProvider = this.interceptorHelper.getServiceProviderType(request, response);
        String operationName = this.interceptorHelper.getOperationName(request, response);
        String msg = "User '" + username + "' accessed the service " + serviceName + "." + serviceType + ". Service provider is " + serviceProvider + ". " + (String)(operationName != null && !operationName.isEmpty() ? "Performed the operation - '" + operationName + "'." : "");
        this.logger.info(msg);
    }
}

