---
order: 1
---

# Audit Log Interceptor

This sample demonstrates how you can intercept any REST based GIS service of any type (MapServer, FeatureServer, KnowledgeGraph, etc.) published within ArcGIS Enterprise or stand-alone ArcGIS Server environment. This sample intercepts incoming requests and logs relevant information, including the username of the individual accessing the services, the service name, the service type, and any operations performed by the user on the service.


## Download the sample code
The pre-built audit log interceptor sample is available here: (`../AuditLogInterceptor/target/AuditLogInterceptor.interceptor`)

## Deploy the Interceptor

Deploying the interceptor is done in two parts: uploading and registering.

### Upload and Register

After downloading the interceptor sample, follow the steps below to deploy the interceptor.

1. Unzip the Audit Log Interceptor sample into a directory of your choosing.
2. In a web browser, navigate to the ArcGIS Server Administrator Directory and sign in as an administrator.
3. Click uploads > upload.
4. On the Upload Item page, click the Choose File button and select the AuditLogInterceptor.interceptor file located in the AuditLogInterceptor/target folder in the directory where you unzipped the sample in Step 1 above.
5. Click the Upload button. Once the file is uploaded, you will be directed to the Uploaded Item page. Copy the Item ID.
6. Browse to Home > system.
7. If you do not see a navigation link to interceptors on the page, append /interceptors to the URL in the browser, i.e., <domain>/<server-web-adaptor>/admin/system/interceptors.
8. Click the register link and paste the value of the Item ID from Step 5 above into the input box. Click the Register button.

## Verify the result

Once the interceptor is registered, it is functioning immediately. To inspect the behavior of the audit log interceptor, follow the steps below.

In ArcGIS Server Administrative Directory, navigate to Home > logs > settings > edit. Set the Log Level to INFO and leave all other settings in their default state.
Navigate to <domain>/<server-web-adaptor>/rest/services.
Access any service and perform any operation on that service.
In ArcGIS Server Administrative Directory, navigate to Home > logs > query. Set the Level to INFO. Leave all other settings in their default value and click the Query button.
In the log query results, logs that are generated by service interceptors will a have a value of "Enterprise Interceptor" in the Target column. You should see an INFO level log with the Message: "User XXXX accessed the service <servicename>.<servicetype>. Performed the operation - <operation name>."

