/*
 * Decompiled with CFR 0.152.
 */
package entsdksample;

import com.esri.arcgis.enterprise.interceptor.IInterceptorConfig;
import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.IInterceptorResponse;
import com.esri.arcgis.enterprise.interceptor.Interceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerInterceptorLogger;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptor;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorChain;
import com.esri.arcgis.enterprise.interceptor.server.IServerServicesInterceptorHelper;
import entsdksample.ServiceInterceptorRequest;
import entsdksample.helpers.StringUtils;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Interceptor(name="AccessControl", displayName="Access Control Interceptor", description="Access Control Interceptor", urlPatterns={"Hosted/States/FeatureServer/0"}, properties={"prop1=value1"}, chainingOrder=1)
public class AccessControl
implements IServerServicesInterceptor {
    private IServerServicesInterceptorHelper interceptorHelper;
    private IServerInterceptorLogger logger;
    private Map<String, HashSet<String>> userAccessMap;
    HashSet<String> stateSet = null;

    public void init(IInterceptorConfig interceptorConfig, IServerServicesInterceptorHelper interceptorHelper, IServerInterceptorLogger logger) {
        this.interceptorHelper = interceptorHelper;
        this.logger = logger;
        this.userAccessMap = new HashMap<String, HashSet<String>>();
        this.userAccessMap.put("james12", new HashSet<String>(Arrays.asList("California", "Oregon")));
        this.userAccessMap.put("sam259", new HashSet<String>(Arrays.asList("Washington", "New York")));
        this.userAccessMap.put("tony64", new HashSet<String>(Arrays.asList("Texas", "Oklahoma")));
    }

    public void intercept(IInterceptorRequest request, IInterceptorResponse response, IServerServicesInterceptorChain filterChain) throws IOException, ServletException {
        if (!filterChain.isRestRequestChain()) {
            filterChain.intercept(request, response);
            return;
        }
        ServiceInterceptorRequest serviceRequestWrapper = new ServiceInterceptorRequest(request);
        String operationName = this.interceptorHelper.getOperationName((IInterceptorRequest)serviceRequestWrapper, response);
        if ("query".equalsIgnoreCase(operationName)) {
            String userInfo = this.interceptorHelper.getUsername((IInterceptorRequest)serviceRequestWrapper, response);
            String userName = StringUtils.extractUserName(StringUtils.safeString(userInfo));
            this.logger.info("AccessControl: resolved user '" + userName + "'");
            if (!userName.isEmpty()) {
                if (this.userAccessMap.containsKey(userName)) {
                    this.stateSet = this.userAccessMap.get(userName);
                }
                this.logger.info(this.stateSet != null ? this.stateSet.toString() : "No information available");
                if (this.stateSet != null) {
                    String whereclausename = "where";
                    Map<String, String[]> params = serviceRequestWrapper.getParameterMap();
                    if (params.containsKey(whereclausename)) {
                        String existingWhere = params.get(whereclausename)[0];
                        String stateFilter = StringUtils.createStateWhereClause(this.stateSet);
                        Object newWhere = existingWhere == null || existingWhere.trim().isEmpty() || existingWhere.equalsIgnoreCase("1=1") ? stateFilter : "(" + existingWhere + ") AND (" + stateFilter + ")";
                        serviceRequestWrapper.updateParameter(whereclausename, (String)newWhere);
                    }
                }
            }
        }
        filterChain.intercept((IInterceptorRequest)serviceRequestWrapper, response);
    }

    public void cleanup() {
        this.stateSet = null;
        this.userAccessMap = null;
    }
}

