/*
 * Decompiled with CFR 0.152.
 */
package entsdksample;

import com.esri.arcgis.enterprise.interceptor.IInterceptorRequest;
import com.esri.arcgis.enterprise.interceptor.server.ServerServicesInterceptorRequestWrapper;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ServiceInterceptorRequest
extends ServerServicesInterceptorRequestWrapper {
    private ByteArrayInputStream byteArrayInputStream;
    private BufferedReader reader;
    private ServletInputStream servletInputStream;
    private boolean streamUsed = false;
    private boolean readerUsed = false;
    private byte[] rawBody = new byte[0];
    private String requestBody = "";
    private final Map<String, String[]> parameterMap;
    private final boolean formUrlEncoded;
    private final Charset bodyCharset;

    public ServiceInterceptorRequest(IInterceptorRequest interceptorRequest) {
        super(interceptorRequest);
        this.bodyCharset = ServiceInterceptorRequest.resolveCharset(interceptorRequest.getContentType());
        this.formUrlEncoded = ServiceInterceptorRequest.isFormUrlEncoded(interceptorRequest.getContentType());
        this.parameterMap = new HashMap<String, String[]>(interceptorRequest.getParameterMap());
        this.readRequestBody(interceptorRequest);
    }

    private static Charset resolveCharset(String contentType) {
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                String p = part.trim();
                if (!p.toLowerCase(Locale.ROOT).startsWith("charset=")) continue;
                try {
                    return Charset.forName(p.substring(8).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return StandardCharsets.UTF_8;
    }

    private static boolean isFormUrlEncoded(String contentType) {
        return contentType != null && contentType.toLowerCase(Locale.ROOT).startsWith("application/x-www-form-urlencoded");
    }

    private void readRequestBody(IInterceptorRequest req) {
        try (ServletInputStream in = req.getInputStream();
             ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);){
            int n;
            byte[] buf = new byte[8192];
            while ((n = in.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            this.rawBody = baos.toByteArray();
            this.requestBody = new String(this.rawBody, this.bodyCharset);
            this.byteArrayInputStream = new ByteArrayInputStream(this.rawBody);
            if (this.formUrlEncoded && this.parameterMap.isEmpty() && this.rawBody.length > 0) {
                ServiceInterceptorRequest.parseFormParametersIntoMap(this.requestBody, this.parameterMap, this.bodyCharset);
            }
        }
        catch (Exception e) {
            this.rawBody = new byte[0];
            this.requestBody = "";
            this.byteArrayInputStream = new ByteArrayInputStream(this.rawBody);
        }
    }

    private static void parseFormParametersIntoMap(String body, Map<String, String[]> map, Charset cs) {
        String[] pairs;
        for (String pair : pairs = body.split("&")) {
            if (pair.isEmpty()) continue;
            String[] kv = pair.split("=", 2);
            String rawK = kv.length > 0 ? kv[0] : "";
            String rawV = kv.length > 1 ? kv[1] : "";
            String key = ServiceInterceptorRequest.urlDecode(rawK, cs);
            String value = ServiceInterceptorRequest.urlDecode(rawV, cs);
            String[] prev = map.get(key);
            if (prev == null) {
                map.put(key, new String[]{value});
                continue;
            }
            String[] next = Arrays.copyOf(prev, prev.length + 1);
            next[next.length - 1] = value;
            map.put(key, next);
        }
    }

    private static String urlDecode(String s, Charset cs) {
        try {
            return URLDecoder.decode(s, cs);
        }
        catch (Exception e) {
            return s;
        }
    }

    private static String urlEncode(String s, Charset cs) {
        try {
            return URLEncoder.encode(s, cs);
        }
        catch (Exception e) {
            return s;
        }
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getDecodedFormBodyOrEmpty() {
        return this.formUrlEncoded ? ServiceInterceptorRequest.urlDecode(this.requestBody, this.bodyCharset) : "";
    }

    public BufferedReader getReader() {
        if (this.streamUsed) {
            throw new IllegalStateException("ServletInputStream already obtained");
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.rawBody), this.bodyCharset));
            this.readerUsed = true;
        }
        return this.reader;
    }

    public ServletInputStream getInputStream() {
        if (this.readerUsed) {
            throw new IllegalStateException("Reader already obtained");
        }
        if (this.servletInputStream == null) {
            this.byteArrayInputStream = new ByteArrayInputStream(this.rawBody);
            this.servletInputStream = new ServletInputStream(){

                public boolean isFinished() {
                    return ServiceInterceptorRequest.this.byteArrayInputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() {
                    return ServiceInterceptorRequest.this.byteArrayInputStream.read();
                }
            };
            this.streamUsed = true;
        }
        return this.servletInputStream;
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public void updateParameter(String key, String newValue) {
        this.parameterMap.put(key, new String[]{newValue});
        if (this.formUrlEncoded) {
            this.rebuildFormBodyFromParameterMap();
        }
    }

    public void updateParameter(String key, String[] newValues) {
        this.parameterMap.put(key, newValues);
        if (this.formUrlEncoded) {
            this.rebuildFormBodyFromParameterMap();
        }
    }

    public void removeParameter(String key) {
        this.parameterMap.remove(key);
        if (this.formUrlEncoded) {
            this.rebuildFormBodyFromParameterMap();
        }
    }

    public void updateRequestBody(String newRequestBody) {
        this.requestBody = newRequestBody != null ? newRequestBody : "";
        this.rawBody = this.requestBody.getBytes(this.bodyCharset);
        this.resetBodyStreams();
    }

    private void rebuildFormBodyFromParameterMap() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String[]> e : this.parameterMap.entrySet()) {
            String k = e.getKey();
            String[] vals = e.getValue();
            if (vals == null || vals.length == 0) {
                if (!first) {
                    sb.append('&');
                }
                sb.append(ServiceInterceptorRequest.urlEncode(k, this.bodyCharset)).append('=');
                first = false;
                continue;
            }
            for (String v : vals) {
                if (!first) {
                    sb.append('&');
                }
                sb.append(ServiceInterceptorRequest.urlEncode(k, this.bodyCharset)).append('=').append(ServiceInterceptorRequest.urlEncode(v != null ? v : "", this.bodyCharset));
                first = false;
            }
        }
        this.requestBody = sb.toString();
        this.rawBody = this.requestBody.getBytes(this.bodyCharset);
        this.resetBodyStreams();
    }

    private void resetBodyStreams() {
        this.byteArrayInputStream = new ByteArrayInputStream(this.rawBody);
        this.reader = null;
        this.servletInputStream = null;
        this.streamUsed = false;
        this.readerUsed = false;
    }

    public int getContentLength() {
        return this.rawBody.length;
    }

    public long getContentLengthLong() {
        return this.rawBody.length;
    }
}

