//   Copyright 2025 Esri
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

import 'dart:io';
import 'package:flutter/services.dart';
import 'package:path_provider/path_provider.dart';

import 'package:flutter/material.dart';
import 'package:arcgis_maps/arcgis_maps.dart';

void main() {

  ArcGISEnvironment.apiKey = 'YOUR_ACCESS_TOKEN';

  runApp(const MaterialApp(home: MainApp()));
}

class MainApp extends StatefulWidget {
  const MainApp({super.key});

  @override
  State<MainApp> createState() => _MainAppState();
}

class _MainAppState extends State<MainApp> {
  final _mapViewController = ArcGISMapView.createController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        children: [
          Expanded(
            child: ArcGISMapView(
              controllerProvider: () => _mapViewController,
              onMapViewReady: onMapViewReady,
            ),
          ),
        ],
      ),
    );
  }


  void onMapViewReady() async {

    const mobileMapPackageName = 'MahouRivieraTrails.mmpk';

    // Retrieve the mobile map package from the asset bundle.
    final mobileMapPackageData = await rootBundle.load(
      'assets/$mobileMapPackageName',
    );

    // Path to a temporary directory on the device.
    // NOTE: This location is not backed up and is suitable for storing
    // caches of downloaded files, in this case, your mobile map package.
    final platformTempDir = await getTemporaryDirectory();

    // Define the path on the device to the mobile map package.
    final pathToFile = '${platformTempDir.absolute.path}/$mobileMapPackageName';

    // Create a new file using the path to the mobile map package.
    final mobileMapPackageFile = File(pathToFile);

    // Synchronously write the mobile map package to the file
    // on the device.
    mobileMapPackageFile.writeAsBytesSync(
      mobileMapPackageData.buffer.asUint8List(),
      flush: true,
    );

    // Create a mobile map package using the Uri to the mobile map package file.
    final mobileMapPackage = MobileMapPackage.withFileUri(
      mobileMapPackageFile.uri,
    );

    // Load the metadata for the mobile map package.
    await mobileMapPackage.load();

    // Check that the mobile map package is not empty.
    if (mobileMapPackage.maps.isNotEmpty) {
      // Display the first map in the mobile map package in the map
      // view controller.
      _mapViewController.arcGISMap = mobileMapPackage.maps.first;
    }

  }

}

