// Copyright 2024 Esri
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import SwiftUI
import ArcGIS
import ArcGISToolkit
@main
struct MainApp: App {
    // The authentication mode.
    private enum AuthenticationMode {
        case apiKey
        case user
    }
    // Change the `AuthenticationMode` to `.apiKey` if your application uses API key authentication.
    // Change the `AuthenticationMode` to `.user` if your application uses OAuth credentials.
    private var authenticationMode: AuthenticationMode { .apiKey }

    // Please enter an API key access token if your application uses API key authentication.
    private let apiKey = APIKey("<#YOUR-ACCESS-TOKEN#>")

    // Setup an `Authenticator` with OAuth configuration if your application uses OAuth credentials.
    @ObservedObject var authenticator = Authenticator(
        oAuthUserConfigurations: [
            OAuthUserConfiguration(
                // Please enter OAuth credentials for user authentication.
                portalURL: URL(string: "<#YOUR-PORTAL-URL#>")!,
                clientID: "<#YOUR-CLIENT-ID#>",
                redirectURL: URL(string: "<#YOUR-REDIRECT-URL#>")!
            )
        ]
    )

    func setAuthentication() {
        switch authenticationMode {
        case .apiKey:
            ArcGISEnvironment.apiKey = apiKey
        case .user:
            ArcGISEnvironment.authenticationManager.arcGISAuthenticationChallengeHandler = authenticator
        }
    }
    
    init() {
        setAuthentication()
    }

    var body: some SwiftUI.Scene {
        WindowGroup {
            ContentView()

                .ignoresSafeArea(edges: .top)

        }
    }

}

